"use strict";
this.name = "Goods Container 30 TC";
this.author = "Reval";
this.licence = "CC BY-NC-SA 4.0";
this.version = "2.0";


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	// keep tally of pylon accessories bought
	this.$gc3Count++;
    // and don't let them exceed ship's pylon-capacity
	if ((equipment == "EQ_GC3_MINE") && (this.$gc3Count<=this.$gc3MCap)) {
		player.ship.cargoSpaceCapacity += 30;
		this.$gc3Containers++;
		pc("Modifying pylon hardpoints for container clamping...",9);
		pc("Fitting 30 TC Class Container #"+this.$gc3Containers+"...",9);
		pc("F4 'Your FE Shipyards' to check your Licence.",9);
	} else
	// unmount & sell cancels all container additions
	if (equipment == "EQ_MISSILE_REMOVAL") {
		player.ship.cargoSpaceCapacity -= this.$gc3Containers*30;
		pc("Removing all 30 TC Class Containers...",9)
		pc("Restoring pylon hardpoints for weapons-use...",9);
		if ((this.$gc3Containers>0) && (!this.$gc3HFExempt)) {
			// dismantling fee
			var dft = this.$gc3Containers*this.$gc3DismantlingFee;
			this.$gc3DismantlingFeeTotal += dft;
			player.credits -= dft;
			pc("Dismantling Fee: "+dft+" cr",9);
		}
		this.$gc3Count = 0;
		this.$gc3Containers = 0;
		// reset system-to-system runs w/containers
		this.$gc3Runs = 0;
		// reset fee totals
		this.$gc3HandlingFeeTotal = 0;
		this.$gc3MaintenanceFeeTotal = 0;
	}
}


this.playerBoughtNewShip = function(ship, price) {
	// missile capacity (not exceed)
	this.$gc3MCap = player.ship.missileCapacity;
	this.$gc3Count = 0;
	this.$gc3Containers = 0;
}


this.equipmentRemoved = function(equipmentKey) {
    if (equipmentKey == "EQ_GC3_MINE") {
		player.ship.cargoSpaceCapacity -= 30;
		this.$gc3Containers--;	
		player.consoleMessage("30 TC Goods Container removed.",5);
	}
}


this.shipReleasedEquipment = function(mine) {
	this.$gc3Count--;
    if (mine == "EQ_GC3_MINE") {
		player.ship.cargoSpaceCapacity -= 30;
		this.$gc3Containers--;
		player.commsMessage("30 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 30000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.shipFiredMissile = function(missile, target) {
	this.$gc3Count--;
    if (missile == "EQ_GC3_MINE") {
		player.ship.cargoSpaceCapacity -= 30;
		this.$gc3Containers--;	
		player.commsMessage("30 TC Goods Container jettisoned.",5);
		// deduct container cost from credits
		player.credits -= 30000.0;
		player.commsMessage("Mishandling charge applied at cost.",9);
	}
}


this.startUpComplete = function () {
	var pc = player.consoleMessage;
	// missile capacity (not exceed)
	this.$gc3MCap = player.ship.missileCapacity;
	this.$gc3Count = player.ship.missiles.length;
	// Load cargo space, missile & container counts if present
	if (missionVariables.gc3Cargo != null) 
		player.ship.cargoSpaceCapacity = missionVariables.gc3Cargo;
	if (missionVariables.gc3Count != null)
		this.$gc3Count = missionVariables.gc3Count;
	if (missionVariables.gc3Containers != null) 
		this.$gc3Containers = missionVariables.gc3Containers;
	// Load total fees taken
	if (missionVariables.gc3HandlingFeeTotal != null)
		this.$gc3HandlingFeeTotal = missionVariables.gc3HandlingFeeTotal;
	if (missionVariables.gc3HandlingPaid != null)
		this.$gc3HandlingPaid = missionVariables.gc3HandlingPaid;
	if (missionVariables.gc3MaintenanceFeeTotal != null)
		this.$gc3MaintenanceFeeTotal = missionVariables.gc3MaintenanceFeeTotal;
	if (missionVariables.gc3DismantlingFeeTotal != null)
		this.$gc3DismantlingFeeTotal = missionVariables.gc3DismantlingFeeTotal; 
    // Load system-to-system runs w/container
	if (missionVariables.gc3Runs != null)
		this.$gc3Runs = missionVariables.gc3Runs;
	// Load Handling fee count
	if (missionVariables.gc3HandlingCount != null)
		this.$gc3HandlingCount = missionVariables.gc3HandlingCount;
	// Load handling fee exemption status
	if (missionVariables.gc3HFExempt != null)
		this.$gc3HFExempt = missionVariables.gc3HFExempt;
	// Load Maintenance fee count
	if (missionVariables.gc3MaintenanceCount != null)
		this.$gc3MaintenanceCount = missionVariables.gc3MaintenanceCount;
	// CHECK
	log(this.name, this.name+" startup complete.");
	// TEST
	var sta = player.ship.dockedStation;
	if ((this.$gc3Containers<this.$gc3MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	// prepare container Account screen
	this._gc3PrepAcc(sta);
	// optionally, prepare handling fee waiver request
	if (this.$gc3Containers>0) this._gc3PrepEx(sta);
}


this.startUp = function() {
    log(this.name, "Initialising OXP " + this.name);
	// check for G.E.T. presence
	this.$gc3ET = false;
	if (worldScripts["Elite Trader"]) 
		this.$gc3ET = true;
	// TEST	
	if (this.$gc3ET) log(this.name, "Finds Elite Trader present");
	// check for FE Ships Player
	this.$gc3FES = false;
	if (worldScripts["FE Ships Player"]) 
		this.$gc3FES = true;
	// TEST	
	if (this.$gc3ET) log(this.name, "Finds FE Ships Player present");
	// missile capacity (not exceed)
	this.$gc3MCap = 0;
	// pylon-use count
	this.$gc3Count = 0;
	// container count
	this.$gc3Containers = 0;
	// purchase cost of container in cr
	this.$gc3Cost = 30000;
	// handling fee
	this.$gc3HandlingFee = 0.005*this.$gc3Cost; // 0.005 of cost
	this.$gc3HandlingFeeTotal = 0;
	this.$gc3HandlingPaid = "yes"; // or "no" - easier than boolean
	this.$gc3HandlingCount = 0;
	this.$gc3HFExempt = "no";
	// maintenance fee
	this.$gc3MaintenanceFee = 0.05*this.$gc3Cost; // 0.05 of cost
	this.$gc3MaintenanceFeeTotal = 0;
	this.$gc3MaintenancePaid = "no" // or "yes"
	this.$gc3MaintenanceInterval = 30; // in runs (according to cost)
	this.$gc3MaintenanceCount = 0;
	// dismantling fee
	this.$gc3DismantlingFee = 0.1*this.$gc3Cost; // 0.1 of cost
	this.$gc3DismantlingFeeTotal = 0.0;
	// system-to-system runs w/container
	this.$gc3Runs = 0;
}


this.playerWillSaveGame = function(message) {
	missionVariables.gc3Count = this.$gc3Count;
	missionVariables.gc3Cargo = player.ship.cargoSpaceCapacity;
	missionVariables.gc3Containers = this.$gc3Containers;
	// save total fees taken
	missionVariables.gc3HandlingFeeTotal = this.$gc3HandlingFeeTotal;
	missionVariables.gc3MaintenanceFeeTotal = this.$gc3MaintenanceFeeTotal;
	missionVariables.gc3DismantlingFeeTotal = this.$gc3DismantlingFeeTotal;
	missionVariables.gc3HandlingPaid = this.$gc3HandlingPaid;
	// system-to-system runs w/container
	missionVariables.gc3Runs =this.$gc3Runs;
	// handling fee count
	missionVariables.gc3HandlingCount = this.$gc3HandlingCount;
	// handling fee exemption (G.E.T.)
	missionVariables.gc3HFExempt = this.$gc3HFExempt;
	// maintenance fee count
	missionVariables.gc3MaintenanceCount = this.$gc3MaintenanceCount;
}


this.shipDockedWithStation = function(station) {
	// take handling fee (if not exempt)
	var pc = player.consoleMessage;
	var ex = this.$gc3HFExempt;
	// check we have containers, the fee is not paid, and we're not exempt
	if ((this.$gc3Containers>0) && (this.$gc3HandlingPaid==="no") && (ex==="no")) {
		var fee = 0;
		for (var x=1; x<= this.$gc3Containers; x++)
			fee += this.$gc3HandlingFee;
		// record fee and debit trader's account
		this.$gc3HandlingFeeTotal += fee;
		player.credits -= fee;
		this.$gc3HandlingPaid = "yes";
		pc("30 TC Container handling fees: "+fee+" cr",9);
		this.$gc3HandlingCount++;
	}

	// conditionally take maintenance fee
	if (this.$gc3Containers>0) this._gc3DoMaintenance();

	// TEST
	if ((this.$gc3Containers<this.$gc3MCap) && (system.techLevel>=6))
		pc("Containers available in the Shipyard.");
	
	// prepare container Account and Licence page
	this._gc3PrepAcc(station);
	
	// prepare handling fee waiver request if ET or FESP is present
	if (this.$gc3Containers>0) this._gc3PrepEx(station);
}



this.shipExitedWitchspace = function() {
	// set handling paid to 'no'
	this.$gc3HandlingPaid = "no";
	this.$gc3Runs ++;
}


/* Common helper functions */


// assess and take maintenance fee
this._gc3DoMaintenance = function() {
	var pc = player.consoleMessage;
	var runs = this.$gc3Runs;
	var intv = this.$gc3MaintenanceInterval;
	var mfee = this.$gc3MaintenanceFee;
	// take maintenance fee after y runs
	if ( (runs > 0) && ((runs % intv)==0) ) {
		// maintenance for x containers
		var fee = 0;
		for (var x=1; x<= this.$gc3Containers; x++)
			fee += mfee;
		// maintenance fee tally & debit
		this.$gc3MaintenanceFeeTotal += fee;
		player.credits -= fee;
		pc("30 TC Container Maintenance fees: "+fee+" cr",9);
		// update Maintenance count
		this.$gc3MaintenanceCount++;
	}
}


/* F4 Interfaces */


// create F.E.S. 'Licence & Account' page 
this._gc3PrepAcc = function(station) {
	station.setInterface("gc3Acc",{
	title: "Your FE Shipyards 30 TC Container Class Licence",
	category: "Your FE Shipyards",
	summary: "Your FE Shipyards 30 TC Goods Container account screen shows terms, fees paid, load, and other useful information.",
	callback: this._gc3ShowAcc.bind(this)
	});	
}


// show F.E.S. 'Licence & Account' page
this._gc3ShowAcc = function() {
	var hfc = this.$gc3HandlingCount;
	var mfc = this.$gc3MaintenanceCount;
	var mfi = this.$gc3MaintenanceInterval;
	var hft = this.$gc3HandlingFeeTotal;
	var mft = this.$gc3MaintenanceFeeTotal;
	var dft = this.$gc3DismantlingFeeTotal;
		
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	if (this.$gc3Containers>0) 
		parameters.message +="Your Account and Licence for 30 TC Class Goods Containers x "+this.$gc3Containers+": \n\n"; 
	 else
		parameters.message +="You have no 30 TC Class Containers licensed with us at this time. \n\n";
	
	parameters.message +="Handling fees paid: "+hft+" cr ("+hfc+") \n";
	parameters.message +="Maintenance fees paid: "+mft+" cr ("+mfc+") \n";
	parameters.message +="Dismantling fees paid: "+dft+" cr \n\n";
	
	parameters.message += "Our containers are re-used many times per cycle, often many times per day. Maintaining them in clean and serviceable condition for their maximum useful lifetime is our prime concern at FE Shipyards, and we trust that you, our valued customer, understand the need for your own participation in this costly and ongoing process. \n\n";
	
	parameters.message += "The handling charge (0.005 of cost) is levied upon docking, the maintenance fee (0.05 of cost) every "+mfi+" system-to-system trading runs. \n\n"
	
	parameters.message += "If you cancel your Container account with us at any time, we must charge the dismantling fee (0.1 of cost) to re-modify and restore your vessel's pylons for weapons-use. \n";
	
	parameters.choicesKey = "gc3Acknowlege";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_YES")  player.commsMessage("FE Shipyards thanks you for your custom.");
	}
}



// create F.E.S. handling fee waiver/restoration request  
this._gc3PrepEx = function(station) {
	station.setInterface("gc3Ex",{
	title: "Your FE Shipyards Handling Fee Waiver Request",
	category: "Your FE Shipyards",
	summary: "FE Shipyards grants Guilders and FE shipowners the privileged option to waive our handling and dismantling fees for the 30-ton container class." ,
	callback: this._gc3ShowEx.bind(this)
	});	
}


// show F.E.S. handling & dismantling fee waiver/restoration request
this._gc3ShowEx = function() {
	var priv = ((this.$gc3ET)||(this.$gc3FES));
	var privo = "";
	if (this.$gc3FES) privo="FE shipowner";
	if (this.$gc3ET) privo="Guilder";
	
	var parameters = new Object();
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message += "Re: your request to waive your 30 TC container fees.\n\n"
	
	parameters.message += "The handling fee (0.005 of cost) is taken from your account upon docking, and is merely to cover our attachment/detachment & loading/unloading services. The dismantling fee (0.1 of cost) is charged when re-modifying your pylons for weapons-use after Licence cancellation. \n\n";
	
	if (priv)
		parameters.message += "FE Shipyards grants you, as a "+privo+", the privileged option to waive our handling and dismantling fees, although you are free - and encouraged - to continue supporting our efforts to provide the efficient service you as an Elite Trader deserve. \n\n";
	else
		parameters.message += "FE Shipyards regrets that we are unable at this time to grant you an exemption from fees, which is a privilege of Guilders and FE shipowners exclusively. \n\n";
	
	parameters.message += "Yours attentively,\n\n";
	
	parameters.message += "Siri Chodrum, for Dor Reval (Technical Director)\n";
	

	parameters.choicesKey = "gc3YesNoEx";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		if (choice === "1_AYE")  {
			if (priv) this.$gc3HFExempt = "yes"; else this.$gc3HFExempt = "no";
		} else this.$gc3HFExempt = "no";
		player.commsMessage("FE Shipyards thanks you for your attention.");
	}	
}



